/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.OwlConfig;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class OwlEntity
extends TamableAnimal
implements FlyingAnimal,
IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> OWL_VARIANT = SynchedEntityData.m_135353_(OwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    private float flapping = 1.0f;

    public OwlEntity(EntityType<? extends OwlEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, -1.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        OwlEntity child = (OwlEntity)ModEntityTypes.OWL.get().m_20615_((Level)world);
        child.setVariant(this.getVariantFromParents((AgeableMob)this, entity));
        return child;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, OwlConfig.health()).m_22268_(Attributes.f_22279_, OwlConfig.movementSpeed()).m_22268_(Attributes.f_22280_, OwlConfig.flyingSpeed());
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int colorBrownWeight = (Integer)OwlConfig.get().colorBrownWeight.get();
        int colorWhiteWeight = (Integer)OwlConfig.get().colorWhiteWeight.get();
        int colorBlackWeight = (Integer)OwlConfig.get().colorBlackWeight.get();
        byte variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1, 2}, new int[]{colorBrownWeight, colorWhiteWeight, colorBlackWeight});
        this.setVariant(variant);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredients.OWL_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 5.0f, 1.0f, true));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWL_VARIANT, (Object)0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("OwlVariant")) {
            this.setVariant(compound.m_128445_("OwlVariant"));
        } else {
            this.setVariant((byte)0);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("OwlVariant", this.getVariant());
    }

    public void m_8107_() {
        super.m_8107_();
        this.calculateFlapping();
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        boolean isTamingItem = stack.m_204117_(LivingThingsTags.OWL_TAMING_FOOD);
        if (!this.m_21824_() && isTamingItem) {
            if (!this.m_9236_().m_5776_()) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                if (this.f_19796_.m_188503_(5) == 0) {
                    this.m_21828_(player);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        if (!this.m_29443_() && this.m_21824_() && this.m_21830_((LivingEntity)player) && isTamingItem) {
            this.m_21839_(!this.m_21827_());
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        return super.m_6071_(player, hand);
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(!this.m_20096_() && !this.m_20159_() ? 4 : -1) * 0.3);
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.m_20096_() && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
    }

    public static boolean checkOwlSpawnRules(EntityType<OwlEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.OWL_SPAWNABLE_ON) && OwlEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, worldIn);
        navigation.m_26440_(false);
        navigation.m_7008_(true);
        navigation.m_26443_(true);
        return navigation;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.OWL_FOOD);
    }

    public int m_5792_() {
        return OwlConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    public boolean m_142535_(float p_149683_, float p_149684_, DamageSource p_149685_) {
        return false;
    }

    protected SoundEvent m_7515_() {
        return ModSounds.OWL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return ModSounds.OWL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return ModSounds.OWL_DEATH.get();
    }

    protected void m_142043_() {
        this.m_5496_(ModSounds.OWL_FLY.get(), 0.15f, 1.0f);
    }

    protected void m_7324_(Entity entityIn) {
        if (!(entityIn instanceof Player)) {
            super.m_7324_(entityIn);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_21839_(false);
        return super.m_6469_(source, amount);
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    @Override
    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(OWL_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(OWL_VARIANT, (Object)variant);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.OWL;
    }
}

